 
DO $$
BEGIN
	IF EXISTS (SELECT 1 FROM pg_type WHERE typname = 'rs_equiv_apresentacao') THEN
		DROP TYPE public.rs_equiv_apresentacao cascade;
	END IF;
END$$;

CREATE TYPE public.rs_equiv_apresentacao AS
(
	cd_prod integer,
	ds_prod character varying(255),
	vlr_tabela double precision,
	ds_apres character varying(255),
	ds_arv_merc_equi character varying(255),
	qt_est integer,
	nm_fabric character varying(255),
	ds_sigla_linha character varying(255),
	vlr_custo double precision,
	ordem integer
);

ALTER TYPE public.rs_equiv_apresentacao
    OWNER TO postgres;
	
-----------------------------------------------
----------------PROCEDURE----------------------


-- DROP FUNCTION public.ufd_prod_equiv_apresentacao(integer, integer, integer);

CREATE OR REPLACE FUNCTION public.ufd_prod_equiv_apresentacao(
	integer,
	integer,
	integer)
    RETURNS SETOF rs_equiv_apresentacao 
    LANGUAGE 'plpgsql'
    COST 100
    VOLATILE 
    ROWS 1000
AS $BODY$

	--<<INICIO DO CORPO DA FUNCAO
	-- Function: select * from ufd_est_prod_tbl_desc_preco_fabrica(1, 4, 1, 1)
	--DECLARA AS VARIAVEIS USADAS NA FUNCAO
	DECLARE
	---------------------------------------------------------
	----DECLARA AS VARIAVEIS QUE ESTAO NO CABECALHO DA FUNCAO
	---------------------------------------------------------
	int_cd_filial           ALIAS FOR $1;
	int_cd_prod             ALIAS FOR $2;
	int_Mesma_pres          ALIAS FOR $3;
	
	is_ctr_custo_semafaro   integer;
	returnRec               rs_equiv_apresentacao;
	BEGIN
	
		BEGIN
			CREATE TEMPORARY TABLE temp_rs_equiv_apresentacao
			(	cd_prod integer,
				ds_prod character varying(255),
				vlr_tabela double precision,
				ds_apres character varying(255),
				ds_arv_merc_equi character varying(255),
				qt_est integer,
				nm_fabric character varying(255),
				ds_sigla_linha character varying(255),
				vlr_custo double precision);
			EXCEPTION WHEN OTHERS THEN
			TRUNCATE TABLE temp_rs_equiv_apresentacao; -- TRUNCA A TABELA SE ELA JA EXISTIR NA CORRENTE SESSAO.
		END;
		
		is_ctr_custo_semafaro = COALESCE((SELECT CAST(COALESCE(VALOR, '0') AS integer) FROM PRC_EMP_CONFIG WHERE CD_CHAVE = 'CTR_CUSTO_SEMAFORO'),0);
						
		
		IF COALESCE((SELECT CAST(COALESCE(VALOR, '0') as integer) FROM PRC_EMP_CONFIG WHERE CD_CHAVE='FLAG_TIPO_PESQUISA_EQUIVALENCIA'), 0) = 0  THEN
			INSERT INTO temp_rs_equiv_apresentacao
			SELECT prod.cd_prod,
				   prod.ds_prod,
				   preco.vlr_tabela,
				   ''                                  AS ds_apres,
				   prin_ativo.ds_princ_ativos          AS ds_arv_merc_equi,
				   prod_cpl.qt_est,
				   prod_fabric.nm_fabric,
				   est_arv_merc_linha.ds_sigla_linha,
				   (SELECT CASE is_ctr_custo_semafaro
							 WHEN 0 THEN vlr_custo
							 ELSE vlr_custo_md
						   END
					FROM   est_prod_cpl
					WHERE  cd_emp = 1
						   AND cd_filial = int_cd_filial
						   AND cd_prod = prod.cd_prod) AS vlr_custo
			FROM   est_prod AS prod
				   INNER JOIN est_prod_princ_ativos_est_prod AS prin_ativo_ret
						   ON prod.cd_emp = prin_ativo_ret.cd_emp
							  AND prod.cd_prod = prin_ativo_ret.cd_prod
				   INNER JOIN est_prod_princ_ativos AS prin_ativo
						   ON prin_ativo_ret.cd_princ_ativos = prin_ativo.cd_princ_ativos
				   INNER JOIN est_prod_princ_ativos_est_prod AS prin_ativo_prod_cons
						   ON prin_ativo.cd_princ_ativos = prin_ativo_prod_cons.cd_princ_ativos
							  AND prin_ativo_prod_cons.cd_prod <> prin_ativo_ret.cd_prod
				   INNER JOIN est_prod_cpl AS prod_cpl
						   ON prod.cd_emp = prod_cpl.cd_emp
							  AND prod.cd_prod = prod_cpl.cd_prod
				   INNER JOIN est_prod_preco AS preco
						   ON prod_cpl.cd_emp = preco.cd_emp
							  AND prod_cpl.cd_filial = preco.cd_filial
							  AND prod_cpl.cd_prod = preco.cd_prod
				   INNER JOIN est_prod_fabric AS prod_fabric
						   ON prod.cd_fabric = prod_fabric.cd_fabric
				   INNER JOIN est_prod_est_arv_mercadologica AS prod_arv_merc
						   ON prod.cd_emp = prod_arv_merc.cd_emp
							  AND prod.cd_prod = prod_arv_merc.cd_prod
				   INNER JOIN est_arv_merc_linha
						   ON prod_arv_merc.cd_arv_merc_linha = est_arv_merc_linha.cd_arv_merc_linha
							  AND prod_arv_merc.cd_emp = est_arv_merc_linha.cd_emp
			WHERE  ( prin_ativo_prod_cons.cd_prod = int_cd_prod )
				   AND ( prod_cpl.cd_filial = int_cd_filial )
			ORDER  BY preco.vlr_tabela,prod_cpl.qt_est DESC ;
			
		ELSE
		
			IF int_Mesma_pres = 1 THEN
				INSERT INTO temp_rs_equiv_apresentacao
				SELECT EP_RETORNO.CD_PROD,
					   EP_RETORNO.DS_PROD,
					   EPP.VLR_TABELA,
					   EAMA.DS_APRES,
					   EAME.DS_ARV_MERC_EQUI,
					   EPL.QT_EST,
					   EPF.NM_FABRIC,
					   EAML.DS_SIGLA_LINHA,
					   (SELECT CASE is_ctr_custo_semafaro
								 WHEN 0 THEN VLR_CUSTO
								 ELSE VLR_CUSTO_MD
							   END
						FROM   EST_PROD_CPL
						WHERE  CD_EMP = 1
							   AND CD_FILIAL = int_cd_filial
							   AND CD_PROD = EP_RETORNO.CD_PROD) AS VLR_CUSTO
				FROM   EST_PROD_EST_ARV_MERCADOLOGICA AS EPEAM_RETORNO
					   INNER JOIN EST_PROD AS EP_RETORNO
							   ON EPEAM_RETORNO.CD_EMP = EP_RETORNO.CD_EMP
								  AND EPEAM_RETORNO.CD_PROD = EP_RETORNO.CD_PROD
					   INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA AS EPEAM_CONS
							   ON EPEAM_RETORNO.CD_EMP = EPEAM_CONS.CD_EMP
								  AND EPEAM_RETORNO.CD_APRES = EPEAM_CONS.CD_APRES
								  AND EPEAM_RETORNO.CD_ARV_MERC_EQUI = EPEAM_CONS.CD_ARV_MERC_EQUI
					   INNER JOIN EST_PROD AS EP_CONS
							   ON EPEAM_CONS.CD_EMP = EP_CONS.CD_EMP
								  AND EPEAM_CONS.CD_PROD = EP_CONS.CD_PROD
								  AND EPEAM_CONS.CD_APRES > 0
								  AND EPEAM_CONS.CD_ARV_MERC_EQUI > 0
								  AND EP_RETORNO.CD_PROD <> EP_CONS.CD_PROD
					   INNER JOIN EST_PROD_CPL AS EPL
							   ON EP_RETORNO.CD_EMP = EPL.CD_EMP
								  AND EP_RETORNO.CD_PROD = EPL.CD_PROD
					   INNER JOIN EST_PROD_PRECO AS EPP
							   ON EPL.CD_EMP = EPP.CD_EMP
								  AND EPL.CD_FILIAL = EPP.CD_FILIAL
								  AND EPL.CD_PROD = EPP.CD_PROD
					   INNER JOIN EST_ARV_MERC_EQUIVALENTE AS EAME
							   ON EPEAM_RETORNO.CD_EMP = EAME.CD_EMP
								  AND EPEAM_RETORNO.CD_ARV_MERC_EQUI = EAME.CD_ARV_MERC_EQUI
					   INNER JOIN EST_ARV_MERC_APRESENTACAO AS EAMA
							   ON EPEAM_RETORNO.CD_EMP = EAMA.CD_EMP
								  AND EPEAM_RETORNO.CD_APRES = EAMA.CD_APRES
					   INNER JOIN EST_PROD_FABRIC AS EPF
							   ON EP_RETORNO.CD_FABRIC = EPF.CD_FABRIC
					   INNER JOIN EST_ARV_MERC_LINHA AS EAML
							   ON EPEAM_RETORNO.CD_EMP = EAML.CD_EMP
								  AND EPEAM_RETORNO.CD_ARV_MERC_LINHA = EAML.CD_ARV_MERC_LINHA
				WHERE  ( EPL.CD_FILIAL = int_cd_filial )
					   AND ( EP_CONS.CD_PROD = int_cd_prod )
				ORDER  BY EAMA.DS_APRES,EPP.VLR_TABELA,EPL.QT_EST DESC ;

			ELSE
				INSERT INTO temp_rs_equiv_apresentacao
				SELECT EP_RETORNO.CD_PROD,
					   EP_RETORNO.DS_PROD,
					   EPP.VLR_TABELA,
					   EAMA.DS_APRES,
					   EAME.DS_ARV_MERC_EQUI,
					   EPL.QT_EST,
					   EPF.NM_FABRIC,
					   EAML.DS_SIGLA_LINHA,
					   (SELECT CASE is_ctr_custo_semafaro
								 WHEN 0 THEN VLR_CUSTO
								 ELSE VLR_CUSTO_MD
							   END
						FROM   EST_PROD_CPL
						WHERE  CD_EMP = 1
							   AND CD_FILIAL = int_cd_filial
							   AND CD_PROD = EP_RETORNO.CD_PROD) AS VLR_CUSTO
				FROM   EST_PROD_EST_ARV_MERCADOLOGICA AS EPEAM_RETORNO
					   INNER JOIN EST_PROD AS EP_RETORNO
							   ON EPEAM_RETORNO.CD_EMP = EP_RETORNO.CD_EMP
								  AND EPEAM_RETORNO.CD_PROD = EP_RETORNO.CD_PROD
					   INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA AS EPEAM_CONS
							   ON EPEAM_RETORNO.CD_EMP = EPEAM_CONS.CD_EMP
								  AND EPEAM_RETORNO.CD_ARV_MERC_EQUI = EPEAM_CONS.CD_ARV_MERC_EQUI
					   INNER JOIN EST_PROD AS EP_CONS
							   ON EPEAM_CONS.CD_EMP = EP_CONS.CD_EMP
								  AND EPEAM_CONS.CD_PROD = EP_CONS.CD_PROD
								  AND EPEAM_CONS.CD_APRES > 0
								  AND EPEAM_CONS.CD_ARV_MERC_EQUI > 0
								  AND EP_RETORNO.CD_PROD <> EP_CONS.CD_PROD
					   INNER JOIN EST_PROD_CPL AS EPL
							   ON EP_RETORNO.CD_EMP = EPL.CD_EMP
								  AND EP_RETORNO.CD_PROD = EPL.CD_PROD
					   INNER JOIN EST_PROD_PRECO AS EPP
							   ON EPL.CD_EMP = EPP.CD_EMP
								  AND EPL.CD_FILIAL = EPP.CD_FILIAL
								  AND EPL.CD_PROD = EPP.CD_PROD
					   INNER JOIN EST_ARV_MERC_EQUIVALENTE AS EAME
							   ON EPEAM_RETORNO.CD_EMP = EAME.CD_EMP
								  AND EPEAM_RETORNO.CD_ARV_MERC_EQUI = EAME.CD_ARV_MERC_EQUI
					   INNER JOIN EST_ARV_MERC_APRESENTACAO AS EAMA
							   ON EPEAM_RETORNO.CD_EMP = EAMA.CD_EMP
								  AND EPEAM_RETORNO.CD_APRES = EAMA.CD_APRES
					   INNER JOIN EST_PROD_FABRIC AS EPF
							   ON EP_RETORNO.CD_FABRIC = EPF.CD_FABRIC
					   INNER JOIN EST_ARV_MERC_LINHA AS EAML
							   ON EPEAM_RETORNO.CD_EMP = EAML.CD_EMP
								  AND EPEAM_RETORNO.CD_ARV_MERC_LINHA = EAML.CD_ARV_MERC_LINHA
				WHERE  ( EPL.CD_FILIAL = int_cd_filial )
					   AND ( EP_CONS.CD_PROD = int_cd_prod )
				ORDER  BY EAMA.DS_APRES,EPP.VLR_TABELA,EPL.QT_EST DESC ;

			END IF;
			
		END IF;
		
		FOR returnRec IN 
			SELECT * FROM temp_rs_equiv_apresentacao 
		LOOP
			RETURN NEXT returnRec;
		END LOOP;			
	END; --FIM DOS BLOCOS DA FUNCAO

$BODY$;

ALTER FUNCTION public.ufd_prod_equiv_apresentacao(integer, integer, integer)
    OWNER TO postgres;
